// DOM.event.move
//
// 2.0.0
//
// Stephen Band
// https://github.com/stephband/jquery.event.move
//
// Triggers 'movestart', 'move' and 'moveend' events after
// mousemoves following a mousedown cross a distance threshold,
// similar to the native 'dragstart', 'drag' and 'dragend' events.
// Move events are throttled to animation frames. Move event objects
// have the properties:
//
// pageX:
// pageY:     Page coordinates of pointer.
// startX:
// startY:    Page coordinates of pointer at movestart.
// distX:
// distY:     Distance the pointer has moved since movestart.
// deltaX:
// deltaY:    Distance the finger has moved since last event.
// velocityX:
// velocityY: Average velocity over last few events.
!function(e){"function"==typeof define&&define.amd?define([],e):"undefined"!=typeof module&&null!==module&&module.exports?module.exports=e:e()}(function(){var e=Object.assign||window.jQuery&&jQuery.extend,t=8,n=window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.oRequestAnimationFrame||window.msRequestAnimationFrame||function(e,t){return window.setTimeout(function(){e()},25)};!function(){if("function"==typeof window.CustomEvent)return!1;function e(e,t){t=t||{bubbles:!1,cancelable:!1,detail:void 0};var n=document.createEvent("CustomEvent");return n.initCustomEvent(e,t.bubbles,t.cancelable,t.detail),n}e.prototype=window.Event.prototype,window.CustomEvent=e}();var o={textarea:!0,input:!0,select:!0,button:!0},i={move:"mousemove",cancel:"mouseup dragstart",end:"mouseup"},a={move:"touchmove",cancel:"touchend",end:"touchend"},u=/\s+/,c={bubbles:!0,cancelable:!0},r="function"==typeof Symbol?Symbol("events"):{};function d(e){return e[r]||(e[r]={})}function m(e,t,n,o,i){t=t.split(u);var a,c=d(e),r=t.length;function m(e){n(e,o)}for(;r--;)(c[a=t[r]]||(c[a]=[])).push([n,m]),e.addEventListener(a,m)}function f(e,t,n,o){t=t.split(u);var i,a,c,r=d(e),m=t.length;if(r)for(;m--;)if(a=r[i=t[m]])for(c=a.length;c--;)a[c][0]===n&&(e.removeEventListener(i,a[c][1]),a.splice(c,1))}function v(t,n,o){var i=function(e){return new CustomEvent(e,c)}(n);o&&e(i,o),t.dispatchEvent(i)}function s(){}function l(e){e.preventDefault()}function p(e,t){var n,o;if(e.identifiedTouch)return e.identifiedTouch(t);for(n=-1,o=e.length;++n<o;)if(e[n].identifier===t)return e[n]}function g(e,t){var n=p(e.changedTouches,t.identifier);if(n&&(n.pageX!==t.pageX||n.pageY!==t.pageY))return n}function h(e,t){w(e,t,e,Y)}function X(e,t){Y()}function Y(){f(document,i.move,h),f(document,i.cancel,X)}function y(e){f(document,a.move,e.touchmove),f(document,a.cancel,e.touchend)}function w(e,n,o,i){var a=o.pageX-n.pageX,u=o.pageY-n.pageY;a*a+u*u<t*t||function(e,t,n,o,i,a){var u=e.targetTouches,c=e.timeStamp-t.timeStamp,r={altKey:e.altKey,ctrlKey:e.ctrlKey,shiftKey:e.shiftKey,startX:t.pageX,startY:t.pageY,distX:o,distY:i,deltaX:o,deltaY:i,pageX:n.pageX,pageY:n.pageY,velocityX:o/c,velocityY:i/c,identifier:t.identifier,targetTouches:u,finger:u?u.length:1,enableMove:function(){this.moveEnabled=!0,this.enableMove=s,e.preventDefault()}};v(t.target,"movestart",r),a(t)}(e,n,o,a,u,i)}function b(e,t){var n=t.timer;t.touch=e,t.timeStamp=e.timeStamp,n.kick()}function T(e,t){var n=t.target,o=t.event,a=t.timer;f(document,i.move,b),f(document,i.end,T),S(n,o,a,function(){setTimeout(function(){f(n,"click",l)},0)})}function E(e,t){var n=t.target,o=t.event,i=t.timer;p(e.changedTouches,o.identifier)&&(!function(e){f(document,a.move,e.activeTouchmove),f(document,a.end,e.activeTouchend)}(t),S(n,o,i))}function S(e,t,n,o){n.end(function(){return v(e,"moveend",t),o&&o()})}if(m(document,"mousedown",function(e){(function(e){return 1===e.which&&!e.ctrlKey&&!e.altKey})(e)&&(function(e){return!!o[e.target.tagName.toLowerCase()]}(e)||(m(document,i.move,h,e),m(document,i.cancel,X,e)))}),m(document,"touchstart",function(e){if(!o[e.target.tagName.toLowerCase()]){var t=e.changedTouches[0],n={target:t.target,pageX:t.pageX,pageY:t.pageY,identifier:t.identifier,touchmove:function(e,t){!function(e,t){var n=g(e,t);n&&w(e,t,n,y)}(e,t)},touchend:function(e,t){!function(e,t){p(e.changedTouches,t.identifier)&&y(t)}(e,t)}};m(document,a.move,n.touchmove,n),m(document,a.cancel,n.touchend,n)}}),m(document,"movestart",function(e){if(!e.defaultPrevented&&e.moveEnabled){var t={startX:e.startX,startY:e.startY,pageX:e.pageX,pageY:e.pageY,distX:e.distX,distY:e.distY,deltaX:e.deltaX,deltaY:e.deltaY,velocityX:e.velocityX,velocityY:e.velocityY,identifier:e.identifier,targetTouches:e.targetTouches,finger:e.finger},o={target:e.target,event:t,timer:new function(e){var t=e,o=!1,i=!1;function a(e){o?(t(),n(a),i=!0,o=!1):i=!1}this.kick=function(e){o=!0,i||a()},this.end=function(e){var n=t;e&&(i?(t=o?function(){n(),e()}:e,o=!0):e())}}(function(e){(function(e,t,n){var o=n-e.timeStamp;e.distX=t.pageX-e.startX,e.distY=t.pageY-e.startY,e.deltaX=t.pageX-e.pageX,e.deltaY=t.pageY-e.pageY,e.velocityX=.3*e.velocityX+.7*e.deltaX/o,e.velocityY=.3*e.velocityY+.7*e.deltaY/o,e.pageX=t.pageX,e.pageY=t.pageY})(t,o.touch,o.timeStamp),v(o.target,"move",t)}),touch:void 0,timeStamp:e.timeStamp};void 0===e.identifier?(m(e.target,"click",l),m(document,i.move,b,o),m(document,i.end,T,o)):(o.activeTouchmove=function(e,t){!function(e,t){var n=t.event,o=t.timer,i=g(e,n);i&&(e.preventDefault(),n.targetTouches=e.targetTouches,t.touch=i,t.timeStamp=e.timeStamp,o.kick())}(e,t)},o.activeTouchend=function(e,t){E(e,t)},m(document,a.move,o.activeTouchmove,o),m(document,a.end,o.activeTouchend,o))}}),window.jQuery){var k="startX startY pageX pageY distX distY deltaX deltaY velocityX velocityY".split(" ");jQuery.event.special.movestart={setup:function(){return m(this,"movestart",K),!1},teardown:function(){return f(this,"movestart",K),!1},add:Q},jQuery.event.special.move={setup:function(){return m(this,"movestart",j),!1},teardown:function(){return f(this,"movestart",j),!1},add:Q},jQuery.event.special.moveend={setup:function(){return m(this,"movestart",C),!1},teardown:function(){return f(this,"movestart",C),!1},add:Q}}function K(e){e.enableMove()}function j(e){e.enableMove()}function C(e){e.enableMove()}function Q(e){var t=e.handler;e.handler=function(e){for(var n,o=k.length;o--;)e[n=k[o]]=e.originalEvent[n];t.apply(this,arguments)}}});