"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = RawHTML;

var _react = require("./react");

/**
 * Internal dependencies
 */
// Disable reason: JSDoc linter doesn't seem to parse the union (`&`) correctly.

/** @typedef {{children: string} & import('react').ComponentPropsWithoutRef<'div'>} RawHTMLProps */

/**
 * Component used as equivalent of Fragment with unescaped HTML, in cases where
 * it is desirable to render dangerous HTML without needing a wrapper element.
 * To preserve additional props, a `div` wrapper _will_ be created if any props
 * aside from `children` are passed.
 *
 * @param {RawHTMLProps} props Children should be a string of HTML. Other props
 *                             will be passed through to div wrapper.
 *
 * @return {JSX.Element} Dangerously-rendering component.
 */
function RawHTML({
  children,
  ...props
}) {
  // The DIV wrapper will be stripped by serializer, unless there are
  // non-children props present.
  return (0, _react.createElement)('div', {
    dangerouslySetInnerHTML: {
      __html: children
    },
    ...props
  });
}
//# sourceMappingURL=raw-html.js.map