"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.render = void 0;

var _reactNative = require("react-native");

var _lodash = require("lodash");

var _hooks = require("@wordpress/hooks");

var _react = require("./react");

/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */
const render = (element, id) => {
  class App extends _react.Component {
    constructor() {
      super(...arguments);
      const parentProps = (0, _lodash.omit)(this.props || {}, ['rootTag']);
      (0, _hooks.doAction)('native.pre-render', parentProps);
      this.filteredProps = (0, _hooks.applyFilters)('native.block_editor_props', parentProps);
    }

    componentDidMount() {
      (0, _hooks.doAction)('native.render', this.filteredProps);
    }

    render() {
      return (0, _react.cloneElement)(element, this.filteredProps);
    }

  }

  _reactNative.AppRegistry.registerComponent(id, () => App);
};
/**
 * Render a given element on Native.
 * This actually returns a componentProvider that can be registered with `AppRegistry.registerComponent`
 *
 * @param {WPElement} element Element to render.
 */


exports.render = render;
//# sourceMappingURL=react-platform.native.js.map